/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.api.lyric;

import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.api.pojo.NetEaseMusicLyric;
import com.google.gson.Gson;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class LyricParser {
    private static final Gson GSON = new Gson();
    private static final Pattern LRC_PATTERN = Pattern.compile("\\[(\\d+):(\\d+)\\.(\\d+)](.*)");

    @Nullable
    public static LyricRecord parseLyric(String json, String songName) {
        NetEaseMusicLyric.Lyric translated;
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        NetEaseMusicLyric rawLyric = (NetEaseMusicLyric)GSON.fromJson(json, NetEaseMusicLyric.class);
        if (rawLyric == null) {
            return null;
        }
        if (rawLyric.code() != 200) {
            return null;
        }
        NetEaseMusicLyric.Lyric original = rawLyric.original();
        if (original == null || StringUtils.isBlank((CharSequence)original.lyric())) {
            return null;
        }
        Int2ObjectSortedMap<String> splitOriginal = LyricParser.splitLyric(original.lyric());
        if (splitOriginal.isEmpty()) {
            return null;
        }
        if (!splitOriginal.containsKey(0)) {
            splitOriginal.put(0, (Object)songName);
        }
        if ((translated = rawLyric.translation()) != null && StringUtils.isNotBlank((CharSequence)translated.lyric())) {
            Int2ObjectSortedMap<String> splitTranslated = LyricParser.splitLyric(translated.lyric());
            if (splitTranslated.isEmpty()) {
                return new LyricRecord(splitOriginal);
            }
            if (!splitTranslated.containsKey(0)) {
                splitTranslated.put(0, (Object)songName);
            }
            return new LyricRecord(splitOriginal, splitTranslated);
        }
        return new LyricRecord(splitOriginal);
    }

    private static Int2ObjectSortedMap<String> splitLyric(String lrcContent) {
        String[] lines;
        Int2ObjectRBTreeMap lyrics = new Int2ObjectRBTreeMap();
        if (StringUtils.isBlank((CharSequence)lrcContent)) {
            return lyrics;
        }
        for (String line : lines = lrcContent.split("\n")) {
            Matcher matcher = LRC_PATTERN.matcher(line.trim());
            if (!matcher.find()) continue;
            int minutes = Integer.parseInt(matcher.group(1));
            int seconds = Integer.parseInt(matcher.group(2));
            int milliseconds = Integer.parseInt(matcher.group(3));
            String text = matcher.group(4).trim();
            int totalTick = ((minutes * 60 + seconds) * 1000 + milliseconds) / 50;
            lyrics.put(totalTick, (Object)text);
        }
        return lyrics;
    }
}

